#!/bin/bash

#add VMware package keys
#wget http://packages.vmware.com/tools/keys/VMWARE-PACKAGING-GPG-DSA-KEY.pub -O - | apt-key add -
#wget http://packages.vmware.com/tools/keys/VMWARE-PACKAGING-GPG-RSA-KEY.pub -O - | apt-key add -


#install packages
#apt-get install -y open-vm-tools-deploypkg open-vm-tools


#Stop services for cleanup
service rsyslog stop

#clear custom ntp
cat /dev/null > /home/totpradius/ntp.sh
#clear audit logs
if [ -f /var/log/audit/audit.log ]; then
    cat /dev/null > /var/log/audit/audit.log
fi
if [ -f /var/log/wtmp ]; then
    cat /dev/null > /var/log/wtmp
fi
if [ -f /var/log/lastlog ]; then
    cat /dev/null > /var/log/lastlog
fi


if [ -f /var/log/lastlog ]; then
    cat /dev/null > /var/log/lastlog
fi



#cleanup persistent udev rules
if [ -f /etc/udev/rules.d/70-persistent-net.rules ]; then
    rm /etc/udev/rules.d/70-persistent-net.rules
fi

#cleanup /tmp directories
rm -rf /tmp/*
rm -rf /var/tmp/*
rm -rf /var/www/fido2/.sessions/*
rm -rf /var/www/fido2/.users/*
echo "" >  /var/www/log/log.txt 
echo "" >  /var/www/log/syslog.txt
echo "" > /var/www/ldaps-cert/ca.pem

#clean all logs
truncate -s 0 /var/log/*  
truncate -s 0 /var/log/**/**/* 
truncate -s 0 /var/log/**/* 

#cleanup current ssh keys
rm -f /etc/ssh/ssh_host_*

#add check for ssh keys on reboot...regenerate if neccessary
sed -i -e 's|exit 0||' /etc/rc.local
sed -i -e 's|.*test -f /etc/ssh/ssh_host_dsa_key.*||' /etc/rc.local
bash -c 'echo "test -f /etc/ssh/ssh_host_dsa_key || dpkg-reconfigure openssh-server" >> /etc/rc.local'
bash -c 'echo "exit 0" >> /etc/rc.local'

#reset hostname
#cat /dev/null > /etc/hostname

#cleanup apt
apt-get clean

#cleanup shell history
history -w
history -c
truncate --size 0 eth0
rm /var/log/*log.* -Rf
rm /var/log/apache2/*log.* -Rf
rm /var/log/apache2/*freeradius.* -Rf

#remove nameservers
echo "" > /etc/resolvconf/resolv.conf.d/base

#remove LDAPS Certificate
echo "" > /var/www/ldaps-cert/ca.pem
#remove lease info
#echo "" > /var/lib/dhcp/dhclient.eth0.leases
echo 0 > /var/www/html/admin/lic/sync
echo "checked" > /var/www/html/admin/lic/wizard
echo "0" > /var/www/html/admin/lic/deleted
echo "" > /var/log/freeradius/radius.log
rm /var/log/freeradius/radius.log.1
rm /var/log/freeradius/radius.log.2
rm /var/log/freeradius/radius.log.3
rm /var/log/freeradius/radius.log.4
rm  /var/log/freeradius/*.gz -Rf
rm   /var/log/apache2/*.gz -Rf
echo "" > /var/log/apache2/error.log
echo "" > /var/log/apache2/access.log

php reset_settings.php
