#! /bin/bash

echo "_______________________________________________________________________________________";
echo "";
echo "Token2 TOTPRadius 0.3 Upgrade"
echo "This scripts upgrades the current version of TOTPRadius 0.2.7, 0.2.8 or 0.2.9 to version 0.3"

echo "_______________________________________________________________________________________";


## grep '0.2.7' /home/totpradius/totpradius 
## grep '0.2.8' /home/totpradius/totpradius


echo "";

echo "Checking if this is a 0.2.7, 0.2.8 or 0.2.9";


if  grep -q '0.2.7\|0.2.8\|0.2.9' /home/totpradius/totpradius ; then
      echo " upgrade possible"
else
    echo "no upgrade possible"
    exit
fi

echo "_______________________________________________________________________________________";

echo "";

echo "Checking if this appliance was already upgraded";

echo "";


if  grep -q '0.3.0' /home/totpradius/totpradius ; then
      echo "already 0.3 , no upgrade possible"
      exit
else
    echo " upgrade possible"
    
fi

echo "_______________________________________________________________________________________";


echo "";

echo "Copying upgrade files"
cp -pR /home/totpradius/upgrade/files/*  /var/www/

echo "";

echo "Setting permissions";

echo "";
chown -R totpradius:totpradius  "/var/www/html/admin/lic/" ;
chown -R totpradius:totpradius  "/var/www/" ;
chown -R totpradius:totpradius  "/var/www/html/" ;
chown -R totpradius:totpradius  "/var/www/log/" ;
chmod 777 /var/www/html/admin/lic/trusted
chmod 777 /var/www/html/admin/lic/groups
chmod 777 /var/www/html/admin/lic/syslog
chmod 777 /var/www/html/admin/lic/license
touch /var/www/log/syslog.txt

chown -R totpradius:totpradius /var/www/log/syslog.txt
chmod 777 /var/www/log/syslog.txt
echo "" > /var/www/log/syslog.txt
if test -f "/etc/freeradius/3.0/extra"; then
 echo "The necessary Radius file exists. Keeping existing config"
else
touch /etc/freeradius/3.0/extra
chown freerad:freerad /etc/freeradius/3.0/extra
chmod 755 /etc/freeradius/3.0/extra
fi

echo "_______________________________________________________________________________________";


echo "";


echo "Changing radius configuration";


if  grep -q "'%{Calling-Station-Id}' '%{NAS-IP-Address}'"  /etc/freeradius/3.0/sites-available/default ; then
      echo "Radius config already up-to-date. Keeping existing config"
      
else
    echo " Copying Radius default file"
	cp -pR /home/totpradius/upgrade/default /etc/freeradius/3.0/sites-available/default 
    chown freerad:freerad /etc/freeradius/3.0/sites-available/default
fi

echo "_______________________________________________________________________________________";


echo "";
echo "Writing upgrade information";

/usr/bin/sed -i 's/0.2.8/0.2.9_upgraded_from_0.2.8/g' /home/totpradius/totpradius
/usr/bin/sed -i 's/0.2.7/0.2.9_upgraded_from_0.2.7/g' /home/totpradius/totpradius
/usr/bin/sed -i 's/0.2.3/0.3.0_upgraded_from_0.2.7/g' /home/totpradius/totpradius

echo "_______________________________________________________________________________________";


echo "";
echo "Upgrade completed, please reboot the appliance";




